;  SB-FTP v1.01
;  Basic Usage: "/ftp sitename" or "/ftp site username password"
;  All commands can be access through the popups
;  Questions/Comments to bkennedy@haverford.edu
;  --[SB]Tikiman

alias ftp {
  if ($window(@SB-FTP).x == $null) set %fintro true
  window -aesl20 @SB-FTP @Ftpoff Courier New
  if (%fintro) {
    unset %fintro
    fecho 14-----=====16Welcome to SB-FTP v1.0114=====-----
    fecho 16Right Click to connect to a server
  }
  if ($sock(FTP) == $null) titlebar @SB-FTP -- Not connected
  if ($1) {
    unset %autouser %autopass
    if ($2) { set %autouser $2 }
    if ($3) { set %autopass $3 }
    set %sbig $rand(5,9)
    set %startport $rand(1,20)
    sockclose FTP
    sockclose FTPSERVE
    if (%curport == $null) set %curport 21
    set %site $1
    sockopen FTP $1 %curport
    window @SB-FTP @Ftp
    .timer9987 0 120 noop
  }
}
on 1:sockopen:FTP: {
  clear @SB-FTP | clear -l @SB-Ftp
  if ($sockerr > 1) { fecho 14***16 Connection Error | halt }
  fecho 14***16 Connection Accepted, waiting for login
  titlebar @SB-FTP -- %site -- $sock($sockname).ip $+ , $+ %curport
}
on 1:sockclose:FTP: {
  fecho 14***16 Connection Terminated
  titlebar @SB-FTP -- Not connected
  clear -l @SB-Ftp
  window @SB-FTP @Ftpoff
  .timer9987 off
}
on 1:sockread:FTP: {
  sockread %params 
  set %nmic $gettok(%params,1,32)
  if (%nmic == 250) || (%nmic == 230) {    
    getdir 
    if ( log isin %params) {
      fecho 14***16 Successfully logged in to $sock($sockname).ip
      locdisp $mircdir
    }    
    halt
  }
  if (%nmic == 220) {
    fecho 14***16 Login Received
    if (%autouser) { fsock USER %autouser | unset %autouser | halt }
    fecho 14***16 Please type "USER username"
    editbox @SB-FTP USER
    halt
  }
  if (%nmic == 331) {
    if (%autopass) { fsock PASS %autopass | unset %autopass | halt }
    fecho 14***16 Please type "PASS password"
    editbox @SB-FTP PASS
    halt
  }
  if (%nmic == 226) {
    fecho 14***16 Transfer Complete
    halt
  }
  if (%nmic == 150) {
    fecho 14***16 $gettok(%params,2-999,32)
    halt
  }
  if (%nmic == 221) {
    fecho 14***16 $gettok(%params,2-999,32)
    halt
  }
  if (%nmic == 421) {
    fecho 14***16 $gettok(%params,2-999,32)
    halt
  }
  if (%nmic == 257) {
    fecho 14***16 Successfully Made Directory
    getdir
    halt
  }
  if (%nmic == 350) {
    fsock RNTO %rento
    unset %rento
    halt
  }
  if (%nmic == 530) {
    fecho 14***16 Bad username or password
    editbox @SB-FTP USER
    halt
  }
  if ($left(%params,4) == 230-) {
    fecho $mid(%params,5,999999) $+ $chr(160)
    halt
  }
  if (%nmic == 200) {
    if ($gettok(%params,2,32) == type) && (I isin $gettok(%params,5,32)) {
      fecho 14***16 Binary Mode Enabled
      halt
    }
    if ($gettok(%params,2,32) == type) && (A isin $gettok(%params,5,32)) {
      fecho 14***16 ASCII Mode Enabled
      halt
    }
    if ($gettok(%params,2,32) == PORT) {
      fecho 14***16 PORT Command Succesful
      halt
    }
    if ($gettok(%params,2,32) == NOOP) {
      fecho 14***16 NOOP Command Succusful (Anti-Idle)
      halt
    }
    
  }
  if (%params) { fecho %params }
}
on 1:sockclose:FTP: {
  fecho 14***16 Connection lost
}
on 1:INPUT: {
  if ($active != @SB-FTP) goto end
  if ($1 == USER) {  fsock $1- }
  if ($1 == PASS) {  fsock $1- }
  if ($1 == QUIT) {  fsock $1- }
  if ($1 == CD) {  fsock CWD $2- }
  if ($1 == BIN) { fsock TYPE I }
  if ($1 == ASC) { fsock TYPE A }
  if ($1 == HELP) { fsock HELP }
  if ($1 == DEL) {
    set %toexec  DELE $sline($active,1)
    ybox
    halt
  }
  if ($1 == RAW) { fsock $2- }
  if ($1 == OPEN) { ftp $2 }
  if ($1 == DIR) {  
    getdir
  }  
  if ($1 == FDIR) {  
    fulldir
  }  
  if ($1 == GET) {  
    fileget $2    
  }  
  if ($1 == PUT) {
    fileput $2
  }
  halt
  :end  
}
alias -l listenup {
  sockclose FTPSERVE
  sockclose FTPCLIENT
  fsock PORT $replace($ip,.,$chr(44)) $+ , $+ %sbig $+ , $+ %startport
  set %port $calc( 256 * %sbig + %startport )
  inc %startport
  socklisten FTPSERVE %port
}
on 1:socklisten:FTPSERVE: {
  sockaccept FTPCLIENT
  if (%job == fileput) crammit  
}
on 1:sockread:FTPCLIENT: {
  goto %job
  :list
  sockread %sparams
  if (d isin  $gettok(%sparams,1,32)) {
    lfecho <dir> $gettok(%sparams,9,32)
    halt
  }
  if ( $gettok(%sparams,9,32) == $null) {  halt }
  lfecho $gettok(%sparams,9-99,32)
  halt  
  :flist
  sockread %sparams
  if (%sparams == $null) {  halt }
  write full.txt %sparams
  halt
  :fileget
  :loop
  sockread &bleh
  if (&bleh == $null) goto loop
  bwrite %filename -1 &bleh
  if ($sockbr == 0) upstats
  goto loop
}
on 1:sockclose:FTPCLIENT: {
  if (%job == fileget) { 
    if ($window(@FtpGet).x == $null) goto skip    
    aline @FtpGet Transfer Complete %getqueue
    aline @FtpGet $calc(($ticks - %stime) / 1000) seconds 
    if (%curdir) { aline @Directory $nopath(%filename) }
    if (%getqueue) { .timer 1 1 fileget %getqueue }
    :skip           
  }
  if (%job == flist) { run full.txt }
}
alias -l upstats {
  goto %job
  :fileget
  if ($window(@FtpGet).x == $null) halt
  rline @FtpGet 2 $lof(%filename) Bytes
  halt
}
alias -l getdir {
  fecho 14***16 Receiving Directory
  listenup
  clear -l @SB-Ftp
  set %job list
  fsock LIST
}
alias -l fulldir {
  fecho 14***16 Receiving Directory
  listenup
  set %job flist
  write -c full.txt
  fsock LIST
}
alias -l fileget {
  if (%curdir == $null) {
    if ($exists(download)) set %filename $mircdirdownload\ $+ $1
    else { set %filename $mircdir\ $+ $1 }
  }
  else { set %filename %curdir $+ $1 }
  if ($exists(%filename)) { 
    set %que $$?="File exists, overwrite?"
    if (y !isin %que) halt
  }
  set %fext $gettok(%filename,2,46)  
  if ((%fext == wav) || (%fext == mp3) || (%fext == jpg) || (%fext == gif) || (%fext == zip) || (%fext == exe) || (%fext == au) || (%fext == gz) || (%fext == bmp)) {
    fsock TYPE I 
  }
  listenup
  set %job fileget
  set %getqueue $deltok($1-,1,32)
  write -c %filename
  window -c @FtpGet
  window +tf @FtpGet 20 20 200 87 @Ftpget Courier New
  titlebar @FtpGet of $nopath(%filename)
  aline @FtpGet Begining Transfer
  aline @FtpGet 0 bytes
  set %stime $ticks
  fecho 14***16 Getting %filename
  fsock RETR $1
}
alias -l fileput {
  listenup
  set %job fileput
  set %filename $gettok($1-,1,32)
  set %sendqueue $deltok($1-,1,32)
  window -c @FtpPut
  window +tf @FtpPut 20 20 200 87 @Ftpput Courier New
  titlebar @FtpPut of $nopath(%filename)
  aline @FtpPut Begining Transfer
  aline @FtpPut 0 bytes
  set %stime $ticks
  fecho 14***16 Putting %filename
  fsock STOR $nopath($1)
}
alias -l crammit {
  set %totbytes $lof(%filename)
  set %counter 0
  sendchunk
}
alias -l sendchunk {
  bread %filename %counter 2048 &bleh
  sockwrite -n FTPCLIENT &bleh  
  %counter = %counter + 2048
  if ($window(@FtpPut).x == $null) halt
  rline @FtpPut 2 %counter Bytes
  halt
}
on 1:sockwrite:FTPCLIENT: {
  if (%counter < %totbytes) sendchunk 
  else { 
    sockclose FTPCLIENT 
    if ($window(@FtpPut).x == $null) halt
    aline @FtpPut Transfer Complete 
    aline @FtpPut $calc(($ticks - %stime) / 1000) seconds
    if (%sendqueue) fileput %sendqueue
    else { getdir }
  }
}
menu @FTP {
  dclick {
    if ( $gettok($sline($active,1),1,32) == <dir> )  fsock CWD $gettok($sline($active,1),2,32)
    else { 
      fileget $sline($active,1)
    }
  }
  %empty
  .%alsoempty:halt
  .$nestal2(bogus):halt
  Navigate:halt
  -
  %ghere: { 
    if ( $gettok($sline($active,1),1,32) != <dir> ) { fecho 14***16 Not a Directory | halt }
    fsock CWD $gettok($sline($active,1),2,32)
  }
  Up One Directory:fsock CWD ../
  Enter Directory Name:fsock CWD $$?="Please enter remote directory"
  Make a Directory:fsock MKD $$?="Please enter a new directory"
  %rdir: {
    set %que $$?="Are you sure you wish to remove this directory?"
    if (y !isin %que) halt
    fsock RMD $gettok($sline($active,1),2,32)
  }
  -
  --== %inf1 ==--:halt
  -
  Refresh:getdir
  Get Full Info:fulldir
  Transfer Mode
  . Binary File Mode:fsock TYPE I
  .ASCII File Mode:fsock TYPE A
  %trans: {
    set %tot $sline($active,0)
    unset %getqueue
    set %counter 1
    :loop
    if ( $gettok($sline($active,%counter),1,32) == <dir> ) { goto skip }  
    set %getqueue %getqueue $gettok($sline($active,%counter),1,32)
    :skip
    if (%counter < %tot) { inc %counter | goto loop }
    if (%getqueue == $null) { fecho 14***16 Bad Selection | halt }
    fileget %getqueue
  } 
  Put a File: fileput $$dir="Please Select a File:" 
  %del: { 
    if ( $gettok($sline($active,1),1,32) == <dir> ) { fecho 14***16 Not a File | halt }
    set %toexec fsock DELE $gettok($sline($active,1),1,32)
    ybox
    halt
  }
  %ren1: {
    if ( $gettok($sline($active,1),1,32) == <dir> ) { fecho 14***16 Not a File | halt }
    set %rento $$?="What would you like to name this file?"
    fsock RNFR $gettok($sline($active,1),1,32)
  }
  Local File List:locdisp %curdir
  -
  --== Client ==--:halt
  -
  Connect to a Server:ftp $$?="Please enter a server"
  Current Port -- %curport : set %curport $$?="Please enter a port number:"
  Launch Profile
  .%ftp.fav1:ftp $gettok(%ftp.fav1,1,32) $gettok(%ftp.fav1,2,32) $gettok(%ftp.fav1,3,32) 
  .%ftp.fav2:ftp $gettok(%ftp.fav2,1,32) $gettok(%ftp.fav2,2,32) $gettok(%ftp.fav2,3,32) 
  .%ftp.fav3:ftp $gettok(%ftp.fav3,1,32) $gettok(%ftp.fav3,2,32) $gettok(%ftp.fav3,3,32) 
  .%ftp.fav4:ftp $gettok(%ftp.fav4,1,32) $gettok(%ftp.fav4,2,32) $gettok(%ftp.fav4,3,32) 
  .%ftp.fav5:ftp $gettok(%ftp.fav5,1,32) $gettok(%ftp.fav5,2,32) $gettok(%ftp.fav5,3,32) 
  .%ftp.fav6:ftp $gettok(%ftp.fav6,1,32) $gettok(%ftp.fav6,2,32) $gettok(%ftp.fav6,3,32) 
  .%ftp.fav7:ftp $gettok(%ftp.fav7,1,32) $gettok(%ftp.fav7,2,32) $gettok(%ftp.fav7,3,32) 
  .%ftp.fav8:ftp $gettok(%ftp.fav8,1,32) $gettok(%ftp.fav8,2,32) $gettok(%ftp.fav8,3,32) 
  Manage Profiles
  .Create a Profile: ftpfav
  .Clear a Profile
  ..%ftp.fav1:unset %ftp.fav1*   
  ..%ftp.fav2:unset %ftp.fav2*
  ..%ftp.fav3:unset %ftp.fav3*
  ..%ftp.fav4:unset %ftp.fav4*
  ..%ftp.fav5:unset %ftp.fav5*   
  ..%ftp.fav6:unset %ftp.fav6*
  ..%ftp.fav7:unset %ftp.fav7*
  ..%ftp.fav8:unset %ftp.fav8*
  Quick Help:quhelp
  Comment/Report Bug:ftcomment
  Disconnect:fsock QUIT
}
alias -l nestal2 {
  if ( $sline($active,2) ) {
    unset %stat1 %stat3 %del1 %ren1 %rdir %ghere
    set %inf1 Multiple Files Selected
    set %trans MGet Files
    unset %del
    halt
  }
  if ( $sline($active,1) ) { 
    if ( $gettok($sline($active,1),1,32) == <dir> ) { 
      unset %inf1 %trans %ren1 %del
      set %rdir Remove this Directory
      set %ghere Go Here
      halt      
    }    
    unset %rdir %ghere
    set %inf1 Selected File: $gettok($sline($active,1),1,32)
    set %trans Get this File 
    set %ren1 Rename this File 
    set %del Delete
    halt
  }
  unset %trans %ren1 %del %rdir %ghere
  set %inf1 None Selected
}
menu @Ftpoff {
  --== Client ==--:halt
  -
  Connect to a Server:ftp $$?="Please enter a server"
  Current Port -- %curport : set %curport $$?="Please enter a port number:"
  Launch Profile
  .%ftp.fav1:ftp $gettok(%ftp.fav1,1,32) $gettok(%ftp.fav1,2,32) $gettok(%ftp.fav1,3,32) 
  .%ftp.fav2:ftp $gettok(%ftp.fav2,1,32) $gettok(%ftp.fav2,2,32) $gettok(%ftp.fav2,3,32) 
  .%ftp.fav3:ftp $gettok(%ftp.fav3,1,32) $gettok(%ftp.fav3,2,32) $gettok(%ftp.fav3,3,32) 
  .%ftp.fav4:ftp $gettok(%ftp.fav4,1,32) $gettok(%ftp.fav4,2,32) $gettok(%ftp.fav4,3,32) 
  .%ftp.fav5:ftp $gettok(%ftp.fav5,1,32) $gettok(%ftp.fav5,2,32) $gettok(%ftp.fav5,3,32) 
  .%ftp.fav6:ftp $gettok(%ftp.fav6,1,32) $gettok(%ftp.fav6,2,32) $gettok(%ftp.fav6,3,32) 
  .%ftp.fav7:ftp $gettok(%ftp.fav7,1,32) $gettok(%ftp.fav7,2,32) $gettok(%ftp.fav7,3,32) 
  .%ftp.fav8:ftp $gettok(%ftp.fav8,1,32) $gettok(%ftp.fav8,2,32) $gettok(%ftp.fav8,3,32) 
  Manage Profiles
  .Create a Profile: ftpfav
  .Clear a Profile
  ..%ftp.fav1:unset %ftp.fav1*   
  ..%ftp.fav2:unset %ftp.fav2*
  ..%ftp.fav3:unset %ftp.fav3*
  ..%ftp.fav4:unset %ftp.fav4*
  ..%ftp.fav5:unset %ftp.fav5*   
  ..%ftp.fav6:unset %ftp.fav6*
  ..%ftp.fav7:unset %ftp.fav7*
  ..%ftp.fav8:unset %ftp.fav8*
  Quick Help:quhelp
  Comment/Report Bug:ftcomment
  Quit:window -c $active | window -c @Directory | window -c @FtpGet | window -c @FtpPut
}
alias -l ftpfav {
  if ( %ftp.fav1 ) { 
    if (%ftp.fav2 ) { 
      if (%ftp.fav3 ) {
        if (%ftp.fav4 ) {
          if ( %ftp.fav5 ) { 
            if (%ftp.fav6 ) { 
              if (%ftp.fav7 ) {
                if (%ftp.fav8 ) {                                  
                  echo -a  14***16 All slots full, please clear one                  
                  halt
                } 
                else set %cur 8
              } 
              else set %cur 7
            }
            else set %cur 6
          } 
          else set %cur 5
        } 
        else set %cur 4 
      } 
      else set %cur 3 
    }
    else set %cur 2 
  } 
  else set %cur 1 
  set %ftp.fav $+ %cur $$?="Please enter a ftp site:"
  set %ftp.fav $+ %cur %ftp.fav [ $+ [ %cur ] ] $$?="Please enter a login:"
  set %ftp.fav $+ %cur %ftp.fav [ $+ [ %cur ] ] $$?="Please enter a password:"
}
on 1:CLOSE:@: {
  if (@SB-FTP isin $target) {
    sockclose FTP*
    window -c @FtpGet
    window -c @FtpPut
    window -c @Directory
    unset %curdir
  }
  if (@Directory isin $target) {
    unset %curdir
  }
  if (@Quick isin $target) {
    sockclose QFT*
    unset %tmp.*
  }
  
}
alias -l fecho {
  if ($window(@SB-Ftp).x == $null) halt
  if ($1-) { echo @SB-FTP $1- }
}
alias -l lfecho {
  if ($window(@SB-Ftp).x == $null) halt
  aline -l @SB-FTP $1-
}
alias -l fsock {
  if ($sock(FTP) == $null) {
    fecho 14***16 Connection Lost
    titlebar @SB-FTP -- Not Connected
    window @SB-FTP @Ftpoff
    .timer9987 off
    halt
  }
  sockwrite -n FTP $1-
}
on 1:LOAD: {
  if ($version < 5.3) { echo -a 14***16 Sorry, you need mIRC 5.3 or greater to use this script | .timer 1 1 .unload ftp.mrc | halt }
  ftp
}
menu @Ftpget {
  Run this File:run %filename 
  Close Window:window -c $active
}
menu @FtpPut {
  Close Window:window -c $active
}
alias -l locdisp {
  if (%curdir != $null) {
    if ($1 != %curdir) { 
      set %olddir5 %olddir4
      set %olddir4 %olddir3
      set %olddir3 %olddir2
      set %olddir2 %olddir1
      set %olddir1 %curdir   
    }
  }
  if ($1 == $null) set %curdir $sdir="Please select a directory" %curdir
  else { set %curdir $1 }
  window -c @Directory
  window -sl -t10,20 @Directory 20 20 100 300 @Dir Courier New
  set %counter 1
  :loop
  set %tmp $remove($findfile( [ %curdir ] , *.* , %counter), %curdir)
  ;  if (\ !isin %tmp) && (%tmp != $null) { aline @Directory $left( [ $nopath(%tmp) $str(,20)  ] ,20) $lof(%tmp) | inc %counter | goto loop }
  if (\ !isin %tmp) && (%tmp != $null) { aline @Directory $nopath(%tmp) | inc %counter | goto loop }
  titlebar @Directory %curdir
}
menu @Dir {
  dclick {
    if ( $sline($active,1) ) pfile
    
  }
  %empty
  .%alsoempty:halt
  .$nestal(bogus):halt
  %stat3:halt
  %stat1:halt
  %stat2:halt
  %put1:pfile  
  %del1: {
    set %que $$?="Are you sure you wish to remove this file?"
    if (y !isin %que) halt
    remove %curdir $+ $sline($active,1) 
    dline $active $sline($active,1).ln 
  }
  %run1:run %curdir $+ $sline($active,1)       
  Close Window:window -c $active
  -
  --== Directory ==--
  Select New Directory:locdisp
  %olddir1:locdisp %olddir1
  %olddir2:locdisp %olddir2
  %olddir3:locdisp %olddir3
  %olddir4:locdisp %olddir4
  %olddir5:locdisp %olddir5
}
alias -l pfile {
  set %tot $sline($active,0)
  unset %sendqueue
  set %counter 1
  :loop
  set %sendqueue %sendqueue %curdir $+ $sline($active,%counter)
  if (%counter < %tot) { inc %counter | goto loop }
  fileput %sendqueue
}
alias -l nestal {
  if ( $sline($active,2) ) {
    unset %stat1 %stat3 %del1 %run1
    set %stat2 Multiple Files Selected
    set %put1 Mput Files
    halt
  }
  if ( $sline($active,1) ) { 
    unset %stat2 
    set %del1 Delete $sline($active,1)
    set %run1 Run $sline($active,1)
    set %stat3 Selected File: $sline($active,1)
    set %put1 Put this File 
    set %stat1 Length -- $lof( [ [ %curdir ] $+ [ $sline($active,1) ] ] ) bytes 
    halt
  }
  unset %del1 %run1 %stat1 %stat2 %stat3 %put1
  
}
alias ybox {
  window -p +bn @Yes\No 180 180 200 95 @Yes\No
  drawrect -f @Yes\No 15 1 1 1 200 100
  drawrect -f @Yes\No 14 1 22 44 60 30
  drawrect -f @Yes\No 14 1 115 44 60 30
  drawtext @Yes\No 0 Times 23 35 49 Yes 
  drawtext @Yes\No 0 Times 23 132 49 No
  drawtext @Yes\No 0 Times 23 45 12 Delete File?
}
menu @Yes\No {
  Mouse: {
    if ($inrect($mouse.x,$mouse.y,22,44,60,30)) { 
      drawtext @Yes\No 6 Times 23 35 49 Yes 
    }
    else {
      drawtext @Yes\No 0 Times 23 35 49 Yes 
    }
    if ($inrect($mouse.x,$mouse.y,115,44,60,30))  { 
      drawtext @Yes\No 6 Times 23 132 49 No
    }
    else {
      drawtext @Yes\No 0 Times 23 132 49 No
    }
  }
  SClick: {
    if ($inrect($mouse.x,$mouse.y,22,44,60,30)) { 
      %toexec
      unset %toexec
      window -c $active
    }
    if ($inrect($mouse.x,$mouse.y,115,44,60,30))  { 
      unset %toexec  
      window -c $active
    }
  }
}
alias noop {
  if ($sock(FTP) == $null) { .timer9987 off | halt }
  fsock NOOP
}
alias quhelp {
  clear $active  
  echo -ai3 14***16 SB-FTP v1.01 Quick Help
  echo -ai3 141)16 To connect to a server -- type "OPEN ftp.sitename.com"
  echo -ai3 142)16 To download a file -- highlight the file in the remote list and double click it
  echo -ai3 143)16 To enter a directory -- highlight the directory in the remote direcotry and double click it
  echo -ai3 144)16 To upload a file -- highlight the file on the local directory list and double click
  echo -ai3 145)16 Quick download -- type "/qftp login:password@ftp.site.com/path/name/file.ext:port"
  echo -ai3 14***16 If you need more help, please consult ftp.txt for more information.  
}
alias qftp {
  set %tmp.long $remove($1-,ftp://)
  if (@ isin $1-) {
    set %tmp.login $gettok($gettok(%tmp.long,1,$asc(@)),1,$asc(:))
    set %tmp.pass $gettok($gettok(%tmp.long,1,$asc(@)),2,$asc(:))
    set %tmp.site $gettok(%tmp.long,2,$asc(@)) 
  }
  else {
    set %tmp.login anonymous
    if ($server) {
      set %tmp.pass  $me $+ @ $+ $ip
    }
    else { set %tmp.pass offline@ $+ $ip }
    set %tmp.site %tmp.long
  }
  set %tmp.port $gettok(%tmp.site,2,$asc(:))  
  if (%tmp.port == $null) { set %tmp.port 21 }
  else { set %tmp.site $deltok(%tmp.site,2,$asc(:)) }    
  set %tmp.count $count(%tmp.site,/)
  set %tmp.sitename $gettok(%tmp.site,1,$asc(/))
  set %tmp.filename $gettok(%tmp.site,$calc(%tmp.count + 1),$asc(/))
  if (%tmp.count == 1 ) { set %tmp.path / } | else { set %tmp.path / $+ $gettok(%tmp.site,2 - [ %tmp.count ] ,$asc(/)) }
  echo -s 16 %tmp.path -- %tmp.filename
  prepdl
  sockclose QFTP
  sockopen QFTP %tmp.sitename %tmp.port
  window +f @QuickFTP 0 0 1000 25 @qftp Courier New
  echo @QuickFTP 14***16 Connecting...
}
alias qfecho {
  if ($window(@QuickFTP).state == $null) {
    unset %tmp.*
    sockclose QFTP*
    halt
  }
  rline @QuickFTP 1 $1-
}
on 1:sockopen:QFTP: {
  if ($sockerr > 1) { qfecho 14***16 Unable to Connect to Server | sockclose QFTP* | unset %tmp.* | .timer 1 5 window -c @QuickFTP | halt }
  qfecho 14***16 Accepted, waiting for login
}
on 1:sockclose:QFTP: {
  qfecho 14***16 Connection Terminated by Server
  sockclose QFTP*
  unset %tmp.*
  .timer 1 5 window -c @QuickFTP
}
on 1:sockread:QFTP: {
  sockread %params 
  set %nmic $gettok(%params,1,32)
  if (%nmic == 230) {    
    if ( log isin %params) {
      qfecho 14***16 Logged in
      sockwrite -n QFTP CWD %tmp.path
      sockwrite -n QFTP TYPE I
    }    
    halt
  }
  if (%nmic == 250) {        
    sockclose QFTPS
    sockclose QFTPC
    set %tmp.tport $rand(50,200)
    set %tmp.big $rand(7,10)
    sockwrite -n QFTP PORT $replace($ip,.,$chr(44)) $+ , $+ %tmp.big $+ , $+ %tmp.tport
    set %tmp.lport $calc( 256 * %tmp.big + %tmp.tport )
    socklisten QFTPS %tmp.lport    
    halt
  }
  if (%nmic == 220) {
    qfecho 14***16 Entering Username
    sockwrite -n QFTP USER %tmp.login
    halt
  }
  if (%nmic == 331) {
    qfecho 14***16 Entering Password
    sockwrite -n QFTP PASS %tmp.pass
    halt
  }
  if (%nmic == 530) {
    qfecho 14***16 Bad username or password -- Closing Connection
    sockclose QFTP*
    unset %tmp.*
    .timer 1 5 window -c @QuickFTP
    halt
  }
  if (%nmic == 550) {
    qfecho 14***16 Bad Path/Filename or Incorrect Permissions -- Closing Connection
    sockclose QFTP*
    unset %tmp.*
    .timer 1 5 window -c @QuickFTP
    halt
  }
  if (%nmic == 200) {
    if ($gettok(%params,2,32) == type) && (I isin $gettok(%params,5,32)) {
      qfecho 14***16 Binary Mode Enabled
      halt
    }
    if (port isin %params) {
      sockwrite -n QFTP RETR %tmp.filename
    }    
  }
}
on 1:socklisten:QFTPS: {
  sockaccept QFTPC
  qfecho 14***16 Connected for Download
  write -c %tmp.wfile
}
alias prepdl {
  if ($exists(download)) set %tmp.wfile $mircdirdownload\ $+ %tmp.filename
  else { set %tmp.wfile $mircdir\ $+ %tmp.filename }
  if ($exists(%tmp.wfile)) { 
    set %que $$?="File exists, overwrite?"
    if (y !isin %que) halt
  }
}
on 1:sockread:QFTPC: {
  :loop
  sockread &bleh
  if ($sockbr == 0) goto end
  bwrite %tmp.wfile -1 &bleh
  goto loop
  :end
  qfecho 14***16 $lof(%tmp.wfile) bytes read for %tmp.wfile
}
on 1:sockclose:QFTPC: {
  qfecho 14***16 File Complete - $lof(%tmp.wfile) bytes read for %tmp.wfile
  sockclose QFTP*
  unset %tmp.*
  .timer 1 5 window -c @QuickFTP
}
menu @qftp {
  dclick window -c $active
  Close:window -c $active
}

on 1:sockopen:FTPCOMMENT: {
  if ($sockerr > 1) { fecho -a 14***16 Connection Error -- Please try again later | halt }
  sockwrite -n FTPCOMMENT HELO $ip
  sockwrite -n FTPCOMMENT MAIL FROM: < $+ %email $+ >
  sockwrite -n FTPCOMMENT RCPT TO: <bkennedy@haverford.edu>
  sockwrite -n FTPCOMMENT DATA
}
on 1:sockread:FTPCOMMENT: {    
  sockread %params
  if (354 == $gettok(%params,1,32)) {
    sockwrite -n FTPCOMMENT Subject: SB-FTP v1.01 Comments
    sockwrite -n FTPCOMMENT Return-Address: %reply
    sockwrite -n FTPCOMMENT Mail sent on $date while on $server from $me
    sockwrite -n FTPCOMMENT Reply to: %reply
    sockwrite -n FTPCOMMENT Comments: %message
    sockwrite -n FTPCOMMENT  .
    sockwrite -n FTPCOMMENT QUIT
    fecho 14***16 Thank you.  Your comments are valued.
    unset %message %reply
    sockclose FTPCOMMENT
    halt
  }  
}
alias ftcomment {
  sockclose FTPCOMMENT
  set %reply $?="Reply address?"
  set %message $?="Comments or concerns?"
  sockopen FTPCOMMENT haverford.edu 25
}
