;bleach(0.3)
;fserv.mrc
alias fs {
  if ($1 == $null) { fserv.tog }
  if ($1 == on) { fserv.tog on }
  if ($1 == off) { fserv.tog off }
  if ($1 == dir) { set %fserv.dir $?2="enter fserve directory" }
  if ($1 == trig) { set %fserv.trigger $?2="enter fserve trigger command" }
  if ($1 == start) { set %fserv.start $?2="# of starting credits" }
  if ($1 == ratio) { set %fserv.ratio $?2="set ratio 1:" }
  if ($1 == max) { set %fserv.maxgets $?2="# of max gets" }
  if ($1 == stats) { fstats }
  if ($1 == junk) { junk.tog }
  if ($1 == joinad) { joinad.tog }
  if ($1 == ban) { .guser fban $2 }
  if ($1 == unban) { .ruser fban $2 }
  if ($1 == leech) { set %nick $2 | set % [ $+ [ %nick ] ] [ $+ [ .credits ] ] leech | .msg %nick file server leecher access awarded | .ruser fban %nick }
  if ($1 == unleech) { set %nick $2 | set % [ $+ [ %nick ] ] [ $+ [ .credits ] ] leech | .msg %nick file server leecher access stripped }
  if ($1 == give) { set %nick $2 | inc % [ $+ [ %nick ] ] [ $+ [ .credits ] ] $3 }
  if ($1 == take) { set %nick $2 | dec % [ $+ [ %nick ] ] [ $+ [ .credits ] ] $3 }
}
alias fserv.tog {
  if ($1 == on) { set %fserv on | echo -a $theme.echo(file server on) | halt }
  if ($1 == off) { set %fserv off | echo -a $theme.echo(file server off) | halt }
  if ($1 == $null) { 
    if (%fserv == on) { set %fserv off | echo -a $theme.echo(file server off) | halt }
    if (%fserv == off) { set %fserv on | echo -a $theme.echo(file server on) | halt }
  }
}
alias joinad.tog { 
  if (%fserv.joinad == on) { 
    set %fserv.joinad off
    halt
  }
  else { 
    set %fserv.joinad on
    halt 
  }
}
alias junk.tog { 
  if (%fserv.junk == accepted) { 
    set %fserv.junk refused
    halt 
  }
  else {
    set %fserv.junk accepted
    halt 
  }
}
alias fstats {
  set %fserv.ratio2 1: $+ %fserv.ratio
  set %fserv.start2 %fserv.start credits
  echo -a $theme.fs.stats1
  echo -a $theme.fs.stats2(status,%fserv)
  echo -a $theme.fs.stats2(filedir,%fserv.dir)
  echo -a $theme.fs.stats2(trigger,%fserv.trigger)
  echo -a $theme.fs.stats2(start,%fserv.start2)
  echo -a $theme.fs.stats2(ratio,%fserv.ratio2)
  echo -a $theme.fs.stats2(maxgets,%fserv.maxgets)
  echo -a $theme.fs.stats2(junk,%fserv.junk)
  echo -a $theme.fs.stats2(joinad,%fserv.joinad)
  echo -a $theme.fs.stats3
  unset %fserv.ratio2
  unset %fserv.start2
}
on 1:TEXT:%fserv.trigger:#: {
  if (%fserv == on) { 
    if ($fserv(0) >= 4) { .notice $nick file server is currently busy! please try again later! $theme.fs.logo | halt }
    else { fserve $nick %fserv.maxgets %fserv.dir }
  }
  if (%fserv == off) { .notice $nick file server is not activated! $theme.fs.logo | halt }
}
on fban:TEXT:%fserv.trigger:#: {
  if (%fserv == on) { .notice $nick file sorry! you are banned from my fserv! $theme.fs.logo }
}
on 1:OPEN:!: {
  .msg =$nick                                
  .msg =$nick +-----------------------------+
  .msg =$nick |          bleach          |
  .msg =$nick |        [bleach/fserv]        |
  .msg =$nick +-----------------------------+
  .msg =$nick                                
  if (% [ $+ [ $nick [ $+ [ .credits ] ] ] ] == $null) { goto newbie }
  if (% [ $+ [ $nick [ $+ [ .credits ] ] ] ] != $null) { goto oldie }
  :newbie
  inc % [ $+ [ $nick [ $+ [ .credits ] ] ] ] %fserv.start 
  .msg =$nick current credit(s) : % [ $+ [ $nick [ $+ [ .credits ] ] ] ]
  halt
  :oldie
  .msg =$nick current credit(s) : % [ $+ [ $nick [ $+ [ .credits ] ] ] ]
  halt
}
on 1:SERV:*: {
  if ($1 == help) { .msg =$nick help: cd dir ls get read stats help exit | halt }
  elseif ($1 == dir) { .msg =$nick $theme.fs.logo }
  elseif ($1 == ls) { .msg =$nick $theme.fs.logo }
  elseif ($1 == cd) { .msg =$nick $theme.fs.logo }
  elseif ($1 == cd..) { .msg =$nick $theme.fs.logo }
  elseif ($1 == read) { .msg =$nick $theme.fs.logo }
  elseif ($1 == exit) { .notice $nick thanks for using my $theme.fs.logo }
  elseif ($1 == bye) { .notice $nick thanks for using my $theme.fs.logo }
  elseif ($1 == stats) { 
    .msg =$nick $theme.fs.logo
    .msg =$nick current credit(s) : % [ $+ [ $nick [ $+ [ .credits ] ] ] ]
    halt
  }  
  elseif ($1 == get) {
    if ( % [ $+ [ $nick [ $+ [ .credits ] ] ] ] >= $lof( $cd [ $+ [ \ [ $+ [ $2 ] ] ] ] ) ) { goto send }
    if ( % [ $+ [ $nick [ $+ [ .credits ] ] ] ] == leech) { goto leech }
    else { goto stop }
    :send
    .msg =$nick $theme.fs.logo
    .msg =$nick now sending : $2
    .msg =$nick current credit(s) : % [ $+ [ $nick [ $+ [ .credits ] ] ] ]
    dcc send $nick $filename
    dec % [ $+ [ $nick [ $+ [ .credits ] ] ] ] $lof( $cd [ $+ [ \ [ $+ [ $2 ] ] ] ] ) 
    halt
    :stop
    .msg =$nick $theme.fs.logo
    .msg =$nick credits needed : $lof( $cd [ $+ [ \ [ $+ [ $2 ] ] ] ] )
    .msg =$nick current credit(s) : % [ $+ [ $nick [ $+ [ .credits ] ] ] ]
    .msg =$nick upload to earn credits!
    halt
    :leech
    .msg =$nick $theme.fs.logo
    .msg =$nick now sending : $2
    .msg =$nick current credit(s) : % [ $+ [ $nick [ $+ [ .credits ] ] ] ]
    dcc send $nick $filename
    halt
  }
  else {
    .msg =$nick $theme.fs.logo
    .msg =$nick invalid command!
    halt
  }
}
on 1:FILERCVD:*.* {
  if (%fserv == on) {
    %file = $mul(%fserv.ratio,$lof($filename))
    inc % [ $+ [ $nick [ $+ [ .credits ] ] ] ] %file
    msg $nick received $nopath($filename) : earned credits %file : total credits % [ $+ [ $nick [ $+ [ .credits ] ] ] ] $theme.fs.logo
    halt
  }
}
on 1:NOTICE:*DCC SEND*:*: {
  if (%fserv == on) && (%fserv.junk == refused) && ($left(1,$3-) isin %filetypes) {
    close -g $nick
    .msg =$nick junk files not accepted : %filetypes
  }
}
on 1:JOIN:# { 
  if (%fserv.joinad == on) && (%fserv == on) { 
    .notice $nick $theme.fs.joinad
  } 
}
